CREATE EXTENSION IF NOT EXISTS postgis;

CREATE SCHEMA IF NOT EXISTS managetickets;

CREATE TABLE
IF NOT EXISTS
managetickets.ticket
(
last_update timestamptz default now(),
ticket_no bigint primary key,
updated_by bigint,
original_call_date text, -- timestamptz, but the raw data has errors (e.g. 23:59pm) so we have to clean it
release_date text,
response_due_by text,
work_to_begin_by text,
expiration_date text,
caller_company_name text,
caller_contact_name text,
caller_alt_contact_name text,
caller_contact_phone text,
caller_contact_fax text,
caller_address text,
caller_email text,
caller_job_site_contact_name text,
caller_job_site_contact_phone text,
dig_type_of_work text,
dig_work_done_for text,
dig_explosives text,
dig_trenchless text,
dig_permit text,
dig_job_number text,
dig_site_state text,
dig_site_place text,
dig_site_address text,
dig_site_county text,
dig_site_subdivision text,
dig_site_intersecting_street text,
dig_site_extent_of_work text,
dig_site_remarks text,
dig_site_nw_lat double precision,
dig_site_nw_lon double precision,
dig_site_se_lat double precision,
dig_site_se_lon double precision,
location geometry(geometry, 4326),
raw_data jsonb
);

CREATE TABLE
IF NOT EXISTS
managetickets.notified
(
ticket_no bigint references managetickets.ticket(ticket_no),
district text,
company_name text,
marking_concerns text,
damage text,
customer_service text,
status text
);

CREATE TABLE
IF NOT EXISTS
managetickets.status_history
(
ticket_no bigint references managetickets.ticket(ticket_no),
date timestamptz,
type text,
district text,
company text,
status text,
notes text
);

CREATE TABLE
IF NOT EXISTS
managetickets.search
(
ticket_no bigint primary key,
url text,
type text,
call_date timestamptz,
excavator_company text,
addr text,
street text,
city text,
state text
);

CREATE UNIQUE INDEX IF NOT EXISTS idx_ticket_last_update_ticket_no ON managetickets.ticket (last_update, ticket_no);
CREATE INDEX IF NOT EXISTS idx_notified_ticket_no ON managetickets.notified (ticket_no);
CREATE INDEX IF NOT EXISTS idx_status_history_ticket_no ON managetickets.status_history (ticket_no);
CREATE UNIQUE INDEX IF NOT EXISTS idx_search_ticket_no ON managetickets.search (ticket_no);
CREATE INDEX IF NOT EXISTS idx_ticket_raw_data ON managetickets.ticket USING gin (raw_data);

CREATE OR REPLACE VIEW managetickets.ticket_todo AS (
     SELECT s.state, s.ticket_no
       FROM managetickets.search s
  LEFT JOIN managetickets.ticket t
         ON s.ticket_no = t.ticket_no
      WHERE t.ticket_no IS NULL
);
CREATE OR REPLACE VIEW managetickets.retrieval_progress AS (
  SELECT 
    state, 
    SUM(CASE WHEN retrieved THEN 1 ELSE 0 END) AS retrieved,
    COUNT(*) - SUM(CASE WHEN retrieved THEN 1 ELSE 0 END) AS remaining,
    COUNT(*) AS available
  FROM (
    SELECT 
      s.state, 
      t.ticket_no IS NOT null AS retrieved
    FROM managetickets.search s 
    LEFT JOIN managetickets.ticket t 
    ON s.ticket_no = t.ticket_no
  ) 
  GROUP BY state 
  ORDER BY state
);
